"use client";

import Link from "next/link";
import Card from "../card/Card";
import styles from "./Products.module.css";
import { usePathname } from "next/navigation";
import { Product } from "@/app/_types";

const Products = ({
  allProducts,
  parentDetails,
  smallPadding,
}: {
  allProducts: Product[];
  parentDetails?: { title: string; description: string };
  smallPadding?: boolean;
}) => {
  const pathname = usePathname();
  const isMainPage = pathname === "/";
  const products = isMainPage ? allProducts?.slice(0, 6) : allProducts;
  const isProductPage = allProducts?.some((products) =>
    products.alias.includes("/proizvod/")
  );
  const description = isMainPage
    ? "Sa više od 20 godina iskustva u proizvodnji, izgradili smo reputaciju pouzdanog proizvođača visokokvalitetnih plastičnih auto delova koji odgovaraju najvišim standardima savremenih vozila."
    : "Kompletna ponuda naših proizvoda na jednom mestu. Praktično organizovano, jednostavno za pretragu.";

  return (
    <section
      className={` ${smallPadding ? styles.smallPadding : ""} ${
        styles.products
      }`}
    >
      <div className="container-small">
        {isMainPage && <h1>proizvodni asortiman</h1>}
        {parentDetails?.title && !isMainPage && <h1>{parentDetails?.title}</h1>}
        {!parentDetails?.description && !isProductPage && (
          <div className={styles.description}>{description}</div>
        )}
        {parentDetails?.description && (
          <div
            dangerouslySetInnerHTML={{ __html: parentDetails?.description }}
          />
        )}
        <div className={styles.grid}>
          {products.map((product: Product) => (
            <Card
              key={product.id || product.alias}
              name={(product?.title || product?.name) as string}
              image={product.image}
              alias={product.alias}
              isNew={product.is_new}
              productCode={product.product_code}
              mediaUpdatedAt={product.media_updated_at || 0}
            />
          ))}
        </div>
        {isMainPage && (
          <Link href="/proizvodi" className="link-red">
            Kompletna ponuda
          </Link>
        )}
      </div>
    </section>
  );
};

export default Products;
